<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class Parcel extends Model 
{

    protected $table = 'parcels';
    public $timestamps = true;

    use SoftDeletes;

    protected $dates = ['deleted_at'];
    protected $fillable = array('shipment_id', 'tracking_id', 'sender_id', 'receiver_id', 'length', 'width', 'height', 'weight');

    public function shipment()
    {
        return $this->belongsTo('App\Models\Shipment', 'shipment_id', 'id');
    }

}